// To parse this JSON data, do
//
//     final registrationResponseModel = registrationResponseModelFromJson(jsonString);

import 'dart:convert';

import '../../global/meassage_model.dart';

RegistrationResponseModel registrationResponseModelFromJson(String str) => RegistrationResponseModel.fromJson(json.decode(str));

String registrationResponseModelToJson(RegistrationResponseModel data) => json.encode(data.toJson());

class RegistrationResponseModel {
    String? remark;
    String? status;
    Message? message;
    Data? data;

    RegistrationResponseModel({
        this.remark,
        this.status,
        this.message,
        this.data,
    });

    factory RegistrationResponseModel.fromJson(Map<String, dynamic> json) => RegistrationResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
    };
}

class Data {
    String? accessToken;
    User? user;
    String? tokenType;

    Data({
        this.accessToken,
        this.user,
        this.tokenType,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        accessToken: json["access_token"],
        user: json["user"] == null ? null : User.fromJson(json["user"]),
        tokenType: json["token_type"],
    );

    Map<String, dynamic> toJson() => {
        "access_token": accessToken,
        "user": user?.toJson(),
        "token_type": tokenType,
    };
}

class User {
    int? id;
    String? firstname;
    String? lastname;
    String? username;
    String? companyName;
    String? ownerName;
    String? email;
    String? dialCode;
    String? countryCode;
    String? countryName;
    String? state;
    String? city;
    String? zip;
    String? mobile;
    String? refBy;
    String? totalBonusGiven;
    String? image;
    String? address;
    String? status;
    String? type;
    String? businessProfileData;
    String? kycRejectionReason;
    String? kv;
    String? ev;
    String? sv;
    String? profileComplete;
    String? verCodeSendAt;
    String? ts;
    String? tv;
    String? tsc;
    String? banReason;
    String? perSendMoneyLimit;
    String? dailySendMoneyLimit;
    String? monthlySendMoneyLimit;
    String? createdAt;
    String? updatedAt;

    User({
        this.id,
        this.firstname,
        this.lastname,
        this.username,
        this.companyName,
        this.ownerName,
        this.email,
        this.dialCode,
        this.countryCode,
        this.countryName,
        this.state,
        this.city,
        this.zip,
        this.mobile,
        this.refBy,
        this.totalBonusGiven,
        this.image,
        this.address,
        this.status,
        this.type,
        this.businessProfileData,
        this.kycRejectionReason,
        this.kv,
        this.ev,
        this.sv,
        this.profileComplete,
        this.verCodeSendAt,
        this.ts,
        this.tv,
        this.tsc,
        this.banReason,
        this.perSendMoneyLimit,
        this.dailySendMoneyLimit,
        this.monthlySendMoneyLimit,
        this.createdAt,
        this.updatedAt,
    });

    factory User.fromJson(Map<String, dynamic> json) => User(
        id: json["id"],
        firstname: json["firstname"].toString(),
        lastname: json["lastname"].toString(),
        username: json["username"].toString(),
        companyName: json["company_name"].toString(),
        ownerName: json["owner_name"].toString(),
        email: json["email"].toString(),
        dialCode: json["dial_code"].toString(),
        countryCode: json["country_code"].toString(),
        countryName: json["country_name"].toString(),
        state: json["state"].toString(),
        city: json["city"].toString(),
        zip: json["zip"].toString(),
        mobile: json["mobile"].toString(),
        refBy: json["ref_by"].toString(),
        totalBonusGiven: json["total_bonus_given"].toString(),
        image: json["image"].toString(),
        address: json["address"].toString(),
        status: json["status"].toString(),
        type: json["type"].toString(),
        businessProfileData: json["business_profile_data"].toString(),
        kycRejectionReason: json["kyc_rejection_reason"].toString(),
        kv: json["kv"].toString(),
        ev: json["ev"].toString(),
        sv: json["sv"].toString(),
        profileComplete: json["profile_complete"].toString(),
        verCodeSendAt: json["ver_code_send_at"].toString(),
        ts: json["ts"].toString(),
        tv: json["tv"].toString(),
        tsc: json["tsc"].toString(),
        banReason: json["ban_reason"].toString(),
        perSendMoneyLimit: json["per_send_money_limit"].toString(),
        dailySendMoneyLimit: json["daily_send_money_limit"].toString(),
        monthlySendMoneyLimit: json["monthly_send_money_limit"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"] .toString(),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "firstname": firstname,
        "lastname": lastname,
        "username": username,
        "company_name": companyName,
        "owner_name": ownerName,
        "email": email,
        "dial_code": dialCode,
        "country_code": countryCode,
        "country_name": countryName,
        "state": state,
        "city": city,
        "zip": zip,
        "mobile": mobile,
        "ref_by": refBy,
        "total_bonus_given": totalBonusGiven,
        "image": image,
        "address": address,
        "status": status,
        "type": type,
        "business_profile_data": businessProfileData,
        "kyc_rejection_reason": kycRejectionReason,
        "kv": kv,
        "ev": ev,
        "sv": sv,
        "profile_complete": profileComplete,
        "ver_code_send_at": verCodeSendAt,
        "ts": ts,
        "tv": tv,
        "tsc": tsc,
        "ban_reason": banReason,
        "per_send_money_limit": perSendMoneyLimit,
        "daily_send_money_limit": dailySendMoneyLimit,
        "monthly_send_money_limit": monthlySendMoneyLimit,
        "created_at": createdAt,
        "updated_at": updatedAt,
    };
}


